import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

//Controller.java
//(C) Joseph Mack 2011, jmack (at) wm7d (dot) net, released under GPL v3 (or any later version)

//inspired by Joseph Bergin's MVC gui at http://csis.pace.edu/~bergin/mvc/mvcgui.html

//Controller is a Listener

class JournalController implements ActionListener 
{

	//Joe: Controller has Model and View hardwired in
	JournalModel model;
	JournalView view;

	public JournalController() 
	{	
		System.out.println ("Controller() listens to update events from button");
	} //Controller()

	//invoked when a button is pressed
	public void actionPerformed(ActionEvent e)
	{
		//uncomment to see what action happened at view
		/*
		System.out.println ("Controller: The " + e.getActionCommand() 
			+ " button is clicked at " + new java.util.Date(e.getWhen())
			+ " with e.paramString " + e.paramString() );
		*/
		System.out.println("Controller: adding new journal entry to Model");
		model.incrementValue();
	} //actionPerformed()


	public void addModel(JournalModel m)
	{
		System.out.println("Controller: adding model");
		this.model = m;
	} //addModel()

	public void addView(JournalView v)
	{
		System.out.println("Controller: adding view");
		this.view = v;
	} //addView()

	public void initModel(int x){
		model.setValue(x);
	} //initModel()

} //Controller
